package com.androidbook.simpledrawing;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.View;

public class DrawTextActivity extends DrawingActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(new ViewWithText(this));
	}

	 private static class ViewWithText extends View {
	        private Paint    mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
	        private Typeface mType;
	        
	        public ViewWithText(Context context) {
	            super(context);

	            mPaint.setTextSize(16);
	        }
	        
	        @Override protected void onDraw(Canvas canvas) {
	            canvas.drawColor(Color.GREEN);

	            mPaint.setTypeface(null);
	            canvas.drawText("Domyślna czcionka (normalna)", 30, 40, mPaint);

	            mType = Typeface.create(Typeface.SANS_SERIF, Typeface.NORMAL);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka bezszeryfowa (normalna)", 30, 60, mPaint);
	            
	            mType = Typeface.create(Typeface.SANS_SERIF, Typeface.BOLD);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka bezszeryfowa (pogrubiona)", 30, 80, mPaint);
	            	          
	            mType = Typeface.create(Typeface.MONOSPACE, Typeface.NORMAL);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka Monospace (normalna)", 30, 100, mPaint);
	            
	            mType = Typeface.create(Typeface.SERIF, Typeface.NORMAL);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka o stałej szer. znaków (normalna)", 30, 120, mPaint);
	            
	            mType = Typeface.create(Typeface.SERIF, Typeface.BOLD);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka szeryfowa (pogrubiona)", 30, 140, mPaint);
	            
	            mType = Typeface.create(Typeface.SERIF, Typeface.ITALIC);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka szeryfowa (kursywa)", 30, 160, mPaint);

	            mType = Typeface.create(Typeface.SERIF, Typeface.BOLD_ITALIC);
	            mPaint.setTypeface(mType);
	            canvas.drawText("Czcionka szeryfowa (pogrubiona kursywa)", 30, 180, mPaint);
	                  	      
	            mPaint.setTypeface(null);
	            mPaint.setTextSize(18);
	            canvas.drawText("Czcionka rozmiaru 18", 30, 220, mPaint);
	            
	            mPaint.setTextSize(22);
	            canvas.drawText("Czcionka rozmiaru 22", 30, 240, mPaint);	            

	            mPaint.setTextSize(20);
	            mPaint.setAntiAlias(false);
	            canvas.drawText("Tekst bez antyaliasingu", 30, 262, mPaint);	

	            mPaint.setAntiAlias(true);
	            mPaint.setFlags(Paint.STRIKE_THRU_TEXT_FLAG|Paint.ANTI_ALIAS_FLAG);
	            canvas.drawText("Tekst przekreślony", 30, 282, mPaint);	
	            
	            mPaint.setFlags(Paint.UNDERLINE_TEXT_FLAG|Paint.ANTI_ALIAS_FLAG);
	            canvas.drawText("Tekst podkreślony", 30, 302, mPaint);	
	            
	        }
	    }
}
